/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power.factory.condition;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.power.factory.condition.ConditionFactory;
import io.github.apace100.origins.registry.ModRegistriesArchitectury;
import io.github.apace100.origins.util.SerializableData;
import io.github.apace100.origins.util.SerializableDataType;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.util.ResourceLocation;

public final class EntityConditionsServer {
    public static void register() {
        EntityConditionsServer.register(new ConditionFactory<LivingEntity>(Origins.identifier("using_effective_tool"), new SerializableData(), (data, entity) -> {
            if (entity instanceof ServerPlayerEntity) {
                PlayerInteractionManager interactionMngr = ((ServerPlayerEntity)entity).field_71134_c;
                if (interactionMngr.field_73088_d) {
                    return ((PlayerEntity)entity).func_234569_d_(entity.field_70170_p.func_180495_p(interactionMngr.field_180240_f));
                }
            }
            return false;
        }));
        EntityConditionsServer.register(new ConditionFactory<LivingEntity>(Origins.identifier("gamemode"), new SerializableData().add("gamemode", SerializableDataType.STRING), (data, entity) -> {
            if (entity instanceof ServerPlayerEntity) {
                PlayerInteractionManager interactionMngr = ((ServerPlayerEntity)entity).field_71134_c;
                return interactionMngr.func_73081_b().func_77149_b().equals(data.getString("gamemode"));
            }
            return false;
        }));
        EntityConditionsServer.register(new ConditionFactory<LivingEntity>(Origins.identifier("advancement"), new SerializableData().add("advancement", SerializableDataType.IDENTIFIER), (data, entity) -> {
            ResourceLocation id = data.getId("advancement");
            if (entity instanceof ServerPlayerEntity) {
                Advancement advancement = entity.func_184102_h().func_191949_aK().func_192778_a(id);
                if (advancement == null) {
                    Origins.LOGGER.warn("Advancement \"" + id + "\" did not exist, but was referenced in an \"origins:advancement\" condition.");
                } else {
                    return ((ServerPlayerEntity)entity).func_192039_O().func_192747_a(advancement).func_192105_a();
                }
            }
            return false;
        }));
    }

    private static void register(ConditionFactory<LivingEntity> conditionFactory) {
        ModRegistriesArchitectury.ENTITY_CONDITION.registerSupplied(conditionFactory.getSerializerId(), () -> conditionFactory);
    }
}

